% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atlas.R
\name{subject.label.from.annot}
\alias{subject.label.from.annot}
\title{Extract a region from an atlas annotation as a label for a subject.}
\usage{
subject.label.from.annot(
  subjects_dir,
  subject_id,
  hemi,
  atlas,
  region,
  return_one_based_indices = TRUE,
  invert = FALSE,
  error_on_invalid_region = TRUE
)
}
\arguments{
\item{subjects_dir, }{string. The FreeSurfer SUBJECTS_DIR, i.e., a directory containing the data for all your subjects, each in a subdir named after the subject identifier.}

\item{subject_id, }{string. The subject identifier.}

\item{hemi, }{string, one of 'lh' or 'rh'. The hemisphere name. Used to construct the names of the label data files to be loaded.}

\item{atlas, }{string. The atlas name. E.g., "aparc", "aparc.2009s", or "aparc.DKTatlas". Used to construct the name of the annotation file to be loaded.}

\item{region, }{string. A valid region name for the annotation, i.e., one of the regions of the atlas.}

\item{return_one_based_indices, }{logical. Whether the indices should be 1-based. Indices are stored zero-based in label files, but R uses 1-based indices. Defaults to TRUE.}

\item{invert, }{logical. If TRUE, return the indices of all vertices which are NOT part of the region. Defaults to FALSE.}

\item{error_on_invalid_region, }{logical. Whether to throw an error if the given region does not appear in the region list of the annotation. If set to FALSE, this will be ignored and an empty vertex list will be returned. Defaults to TRUE.}
}
\value{
integer vector with label data: the list of vertex indices in the label.
}
\description{
The returned label can be used to mask morphometry data, e.g., to set the values of a certain region to NaN or to extract only values from a certain region.
}
\seealso{
Other atlas functions: 
\code{\link{get.atlas.region.names}()},
\code{\link{group.agg.atlas.native}()},
\code{\link{group.agg.atlas.standard}()},
\code{\link{group.annot}()},
\code{\link{group.label.from.annot}()},
\code{\link{label.from.annotdata}()},
\code{\link{label.to.annot}()},
\code{\link{regions.to.ignore}()},
\code{\link{spread.values.over.annot}()},
\code{\link{spread.values.over.hemi}()},
\code{\link{spread.values.over.subject}()},
\code{\link{subject.annot}()},
\code{\link{subject.atlas.agg}()},
\code{\link{subject.lobes}()}
}
\concept{atlas functions}
