% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{colors.have.transparency}
\alias{colors.have.transparency}
\title{Check for the given color strings whether they have transparency, i.e., an alpha channel value != fully opaque.}
\usage{
colors.have.transparency(col_strings, accept_col_names = TRUE)
}
\arguments{
\item{col_strings}{vector of RGB(A) color strings, like \code{c("#FFFFFF", ("#FF00FF"))}.}

\item{accept_col_names}{logical, whether to accept color names like 'white'. Disables all sanity checks.}
}
\value{
logical vector
}
\description{
Check for the given color strings whether they have transparency, i.e., an alpha channel value != fully opaque.
}
\examples{
colors.have.transparency(c("#FFFFFF", "#FF00FF", "#FF00FF00", "red", "#FF00FFDD"));
all((colors.have.transparency(c("#FFFFFF00", "#ABABABAB"))));

}
