% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsdir_abstraction_subject.R
\name{subject.filepath.morph.native}
\alias{subject.filepath.morph.native}
\title{Construct filepath of native space morphometry data file.}
\usage{
subject.filepath.morph.native(
  subjects_dir,
  subject_id,
  measure,
  hemi,
  format = "curv",
  warn_if_nonexistent = FALSE,
  error_if_nonexistent = FALSE
)
}
\arguments{
\item{subjects_dir}{string. The FreeSurfer SUBJECTS_DIR, i.e., a directory containing the data for all your subjects, each in a subdir named after the subject identifier.}

\item{subject_id}{string. The subject identifier}

\item{measure}{string. Name of the vertex-wise measure of morphometry data file. E.g., "area" or "thickness". Used to construct the name of the morphometry file to be loaded.}

\item{hemi}{string, one of 'lh' or 'rh'. The hemisphere name.}

\item{format, }{string. One of 'mgh', 'mgz', 'curv'. Defaults to 'curv'.}

\item{warn_if_nonexistent}{logical. Whether to print a warning if the file does not exist or cannot be accessed. Defaults to FALSE.}

\item{error_if_nonexistent}{logical. Whether to raise an error if the file does not exist or cannot be accessed. Defaults to FALSE.}
}
\value{
string, the file path.
}
\description{
Construct filepath of native space morphometry data file.
}
\examples{
   filepath_lh_thickness =
   subject.filepath.morph.native("/media/ext/data/study1", "subject1", "thickness", "lh");

}
