% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_surface_background.R
\name{collayer.bg.atlas}
\alias{collayer.bg.atlas}
\title{Compute atlas or annotation surface color layer.}
\usage{
collayer.bg.atlas(
  subjects_dir,
  subject_id,
  hemi = "both",
  atlas = "aparc",
  grayscale = !outline,
  outline = FALSE,
  outline_surface = "white"
)
}
\arguments{
\item{subjects_dir}{character string, the FreeSurfer SUBJECTS_DIR.}

\item{subject_id}{character string, the subject identifier.}

\item{hemi}{character string, one of 'lh', 'rh', or 'both'. The latter will merge the data for both hemis into a single vector.}

\item{atlas}{character string, the atlas name. E.g., "aparc", "aparc.2009s", or "aparc.DKTatlas". Used to construct the name of the annotation file to be loaded.}

\item{grayscale}{logical, whether to convert the atlas colors to grayscale}

\item{outline}{logical or integer, whether to draw the atlas regions as outlines only. If an integer, it is interpreted as the outline thickness. The value `TRUE` is equivalent to the integer value `1L` and leads to a thin border. The value `2L` will expand the border by 1. If this is active, the surface mesh of the subject must exist.}

\item{outline_surface}{character string, the surface to load. Only relevant when 'outline' is used.}
}
\value{
a color layer, i.e., vector of color strings in a hemilist
}
\description{
Compute atlas or annotation surface color layer.
}
\note{
Using 'outline' mode is quite slow, and increasing the border thickness makes it even slower.
}
\seealso{
You can plot the return value using \code{\link[fsbrain]{vis.color.on.subject}}.

Other surface color layer: 
\code{\link{collayer.bg.meancurv}()},
\code{\link{collayer.bg.sulc}()},
\code{\link{collayer.bg}()},
\code{\link{collayer.from.annotdata}()},
\code{\link{collayer.from.annot}()},
\code{\link{collayer.from.mask.data}()},
\code{\link{collayer.from.morphlike.data}()},
\code{\link{collayers.merge}()}
}
\concept{surface color layer}
