% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsdir_abstraction_subject.R
\name{apply.labeldata.to.morphdata}
\alias{apply.labeldata.to.morphdata}
\title{Apply a label to morphometry data.}
\usage{
apply.labeldata.to.morphdata(morphdata, labeldata, masked_data_value = NA)
}
\arguments{
\item{morphdata}{numerical vector, the morphometry data for one hemisphere}

\item{labeldata}{integer vector or `fs.label` instance. A label as returned by \code{\link[fsbrain]{subject.label}}.}

\item{masked_data_value}{numerical, the value to set for all morphometry data values of vertices which are *not* part of the label. Defaults to NA.}
}
\value{
numerical vector, the masked data.
}
\description{
This function will set all values in morphdata which are *not* part of the labeldata to NA (or whatever is specified by 'masked_data_value'). This is typically used to ignore values which are not part of the cortex (or any other label) during your analysis.
}
\seealso{
Other label functions: 
\code{\link{apply.label.to.morphdata}()},
\code{\link{subject.mask}()},
\code{\link{vis.labeldata.on.subject}()},
\code{\link{vis.subject.label}()}

Other morphometry data functions: 
\code{\link{apply.label.to.morphdata}()},
\code{\link{group.morph.native}()},
\code{\link{group.morph.standard}()},
\code{\link{subject.morph.native}()},
\code{\link{subject.morph.standard}()}
}
\concept{label functions}
\concept{morphometry data functions}
