% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsdir_abstraction_subject.R
\name{subject.morph.standard}
\alias{subject.morph.standard}
\title{Retrieve standard space morphometry data for a single subject.}
\usage{
subject.morph.standard(subjects_dir, subject_id, measure, hemi,
  fwhm = "10", template_subject = "fsaverage", format = "mgh",
  cortex_only = FALSE)
}
\arguments{
\item{subjects_dir}{string. The FreeSurfer SUBJECTS_DIR, i.e., a directory containing the data for all your subjects, each in a subdir named after the subject identifier.}

\item{subject_id}{string. The subject identifier}

\item{measure}{string. Name of the vertex-wise measure of morphometry data file. E.g., "area" or "thickness". Used to construct the name of the morphometry file to be loaded.}

\item{hemi}{string, one of 'lh', 'rh', or 'both'. The hemisphere name. Used to construct the names of the annotation and morphometry data files to be loaded.}

\item{fwhm}{string. Smoothing as string, e.g. '10' or '25'.}

\item{template_subject}{string. Template subject name, defaults to 'fsaverage'.}

\item{format}{string. One of 'mgh', 'mgz', 'curv'. Defaults to 'mgh'.}

\item{cortex_only}{logical, whether to mask the medial wall, i.e., whether the morphometry data for all vertices which are *not* part of the cortex (as defined by the label file `label/?h.cortex.label`) should be replaced with NA values. In other words, setting this to TRUE will ignore the values of the medial wall between the two hemispheres. If set to true, the mentioned label file needs to exist for the template subject. Defaults to FALSE.}
}
\value{
vector with standard space morph data
}
\description{
Load standard space morphometry data (like 'surf/lh.area.fwhm10.fsaverage.mgh') for a subject from disk. Uses knowledge about the FreeSurfer directory structure to load the correct file.
}
\examples{
\donttest{
   fsbrain::download_optional_data();
   subjects_dir = fsbrain::get_optional_data_filepath("subjects_dir");
   thickness_lh = subject.morph.standard(subjects_dir, "subject1", "thickness", "lh", fwhm='10');
}

}
\seealso{
Other morphometry data functions: \code{\link{apply.label.to.morphdata}},
  \code{\link{apply.labeldata.to.morphdata}},
  \code{\link{group.morph.native}},
  \code{\link{group.morph.standard}},
  \code{\link{subject.morph.native}}
}
\concept{morphometry data functions}
