% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dewPoint.R
\name{calcDewPoint.C}
\alias{calcDewPoint.C}
\title{Calculates dew point from ambient temperature and relative humidity.}
\usage{
calcDewPoint.C(RH, temp)
}
\arguments{
\item{RH}{[in percentage] relative humidity, an integer or double value between 0 and 100.}

\item{temp}{[°C] environmental temperature, an integer or double value between -20 and 60 °C}
}
\value{
dew point value (double)
}
\description{
Calculation of dew point using the approach given in the following paper:
Alduchov and Eskridge (1996),
Improved Magnus' form approximation of saturation vapor pressure. J. Appl. Meteor., 35, 601–609.
}
\examples{
library(frost)
temp <- 25
rh <- 54
calcDewPoint(rh,temp,mode="C")

}
