% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cent_sums}
\alias{cent_sums}
\alias{join_cent_sums}
\alias{unjoin_cent_sums}
\title{Centered sums; join and unjoined.}
\usage{
cent_sums(
  v,
  max_order = 5L,
  na_rm = FALSE,
  wts = NULL,
  check_wts = FALSE,
  normalize_wts = TRUE
)

join_cent_sums(ret1, ret2)

unjoin_cent_sums(ret3, ret2)
}
\arguments{
\item{v}{a vector}

\item{max_order}{the maximum order of the centered moment to be computed.}

\item{na_rm}{whether to remove NA, false by default.}

\item{wts}{an optional vector of weights. Weights are \sQuote{replication}
weights, meaning a value of 2 is shorthand for having two observations
with the corresponding \code{v} value. If \code{NULL}, corresponds to
equal unit weights, the default. Note that weights are typically only meaningfully defined
up to a multiplicative constant, meaning the units of weights are
immaterial, with the exception that methods which check for minimum df will,
in the weighted case, check against the sum of weights. For this reason,
weights less than 1 could cause \code{NA} to be returned unexpectedly due
to the minimum condition. When weights are \code{NA}, the same rules for checking \code{v}
are applied. That is, the observation will not contribute to the moment
if the weight is \code{NA} when \code{na_rm} is true. When there is no
checking, an \code{NA} value will cause the output to be \code{NA}.}

\item{check_wts}{a boolean for whether the code shall check for negative
weights, and throw an error when they are found. Default false for speed.}

\item{normalize_wts}{a boolean for whether the weights should be
renormalized to have a mean value of 1. This mean is computed over elements
which contribute to the moments, so if \code{na_rm} is set, that means non-NA
elements of \code{wts} that correspond to non-NA elements of the data
vector.}

\item{ret1}{an \eqn{ord+1} vector as output by \code{\link{cent_sums}} consisting of
the count, the mean, then the k through ordth centered sum of some observations.}

\item{ret2}{an \eqn{ord+1} vector as output by \code{\link{cent_sums}} consisting of
the count, the mean, then the k through ordth centered sum of some observations.}

\item{ret3}{an \eqn{ord+1} vector as output by \code{\link{cent_sums}} consisting of
the count, the mean, then the k through ordth centered sum of some observations.}
}
\value{
a vector the same size as the input consisting of the adjusted version of the input.
When there are not sufficient (non-nan) elements for the computation, \code{NaN} are returned.
}
\description{
Compute, join, or unjoin centered sums.
}
\note{
The moment computations provided by fromo are 
numerically robust, but will often \emph{not} provide the
same results as the 'standard' implementations,
due to differences in roundoff. We make every attempt to balance
speed and robustness. User assumes all risk from using
the fromo package.
}
\examples{

 set.seed(1234)
 x1 <- rnorm(1e3,mean=1)
 x2 <- rnorm(1e3,mean=1)
 max_ord <- 6L
 rs1 <- cent_sums(x1,max_ord)
 rs2 <- cent_sums(x2,max_ord)
 rs3 <- cent_sums(c(x1,x2),max_ord)
 rs3alt <- join_cent_sums(rs1,rs2)
 stopifnot(max(abs(rs3 - rs3alt)) < 1e-7)
 rs1alt <- unjoin_cent_sums(rs3,rs2)
 rs2alt <- unjoin_cent_sums(rs3,rs1)
 stopifnot(max(abs(rs1 - rs1alt)) < 1e-7)
 stopifnot(max(abs(rs2 - rs2alt)) < 1e-7)

}
\references{
Terriberry, T. "Computing Higher-Order Moments Online."
\url{https://web.archive.org/web/20140423031833/http://people.xiph.org/~tterribe/notes/homs.html}

J. Bennett, et. al., "Numerically Stable, Single-Pass, 
Parallel Statistics Algorithms," Proceedings of IEEE
International Conference on Cluster Computing, 2009.
\doi{10.1109/CLUSTR.2009.5289161}

Cook, J. D. "Accurately computing running variance."
\url{https://www.johndcook.com/standard_deviation/}

Cook, J. D. "Comparing three methods of computing 
standard deviation."
\url{https://www.johndcook.com/blog/2008/09/26/comparing-three-methods-of-computing-standard-deviation/}
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
