% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_scss.R
\name{write_scss}
\alias{write_scss}
\title{Create a 'Quarto' SCSS file}
\usage{
write_scss(path = here::here(), .initialize_proj = FALSE)
}
\arguments{
\item{path}{Character string. Path to the project directory.}

\item{.initialize_proj}{Logical. TRUE only if starting a 
\code{froggeR::quarto_project()}.}
}
\value{
A SCSS file to customize 'Quarto' styling.
}
\description{
This function creates the \code{.scss} file so that any 'Quarto' project can be easily
customized with SCSS styling variables, mixins, and rules.
}
\details{
The function includes a robust YAML handling mechanism that safely adds new SCSS file.

See \code{vignette("customizing-quarto", package = "froggeR")} vignette for more help.
}
\examples{
# Create a temporary directory for testing
tmp_dir <- tempdir()

# Write the SCSS file
write_scss(path = tmp_dir)

# Confirm the file was created (optional, for user confirmation)
file.exists(file.path(tmp_dir, "custom.scss"))

# Clean up: Remove the created file
unlink(file.path(tmp_dir, "custom.scss"))

}
