% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wipe_clean.R
\name{wipe_clean}
\alias{wipe_clean}
\title{Remove All Objects From an Environment}
\usage{
wipe_clean(environment)
}
\arguments{
\item{environment}{The environment that should be wiped clean.}
}
\value{
A character vector containing the names of objects removed, but
called for its side effect of removing all objects from the environment.
}
\description{
Wipe an environment, typically \code{\link{.GlobalEnv}}, clean.
}
\examples{
e <- new.env()
assign("a", 1, envir = e)
assign("b", 1, envir = e)
ls(envir = e)
wipe_clean(envir = e)
ls(envir = e)
RUnit::checkIdentical(length(ls(envir = e)), 0L)
}
\seealso{
Other R memory functions: 
\code{\link{memory_hogs}()}
}
\concept{R memory functions}
