% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_package.R
\name{create_package}
\alias{create_package}
\title{Create a Data Package}
\usage{
create_package(descriptor = NULL)
}
\arguments{
\item{descriptor}{List to be made into a Data Package object.
If undefined, an empty Data Package will be created from scratch.}
}
\value{
A Data Package object.
}
\description{
Initiates a Data Package object, either from scratch or from an existing
list.
This Data Package object is a list with the following characteristics:
\itemize{
\item A \code{datapackage} subclass.
\item All properties of the original \code{descriptor}.
\item A \code{resources} property, set to an empty list if undefined.
\item A \code{directory} property, set to \code{"."} for the current directory if
undefined.
It is used as the base path to access resources with \code{\link[=read_resource]{read_resource()}}.
}
}
\details{
See \code{vignette("data-package")} to learn how this function implements the
Data Package standard.
\code{\link[=check_package]{check_package()}} is automatically called on the created package to make sure
it is valid.
}
\examples{
# Create a Data Package
package <- create_package()

package

# See the structure of the (empty) Data Package
str(package)
}
\seealso{
Other create functions: 
\code{\link{create_schema}()}
}
\concept{create functions}
