% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_schema.R
\name{get_schema}
\alias{get_schema}
\title{Get the Table Schema of a Data Resource}
\usage{
get_schema(package, resource_name)
}
\arguments{
\item{package}{List describing a Data Package, created with \code{\link[=read_package]{read_package()}}
or \code{\link[=create_package]{create_package()}}.}

\item{resource_name}{Name of the Data Resource.}
}
\value{
List describing a Table Schema.
}
\description{
Returns the \href{https://specs.frictionlessdata.io/table-schema/}{Table Schema}
of a Data Resource (in a Data Package), i.e. the content of its \code{schema}
property, describing the resource's fields, data types, relationships, and
missing values.
The resource must be a \href{https://specs.frictionlessdata.io/tabular-data-resource/}{Tabular Data Resource}.
}
\examples{
# Load the example Data Package
package <- example_package

# Get the Table Schema for the resource "observations"
schema <- get_schema(package, "observations")
str(schema)
}
\seealso{
Other edit functions: 
\code{\link{add_resource}()},
\code{\link{remove_resource}()}
}
\concept{edit functions}
