% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mghheader.R
\name{ras.to.talairachras}
\alias{ras.to.talairachras}
\title{Compute MNI talairach coordinates from RAS coords.}
\usage{
ras.to.talairachras(ras_coords, talairach, invert_transform = FALSE)
}
\arguments{
\item{ras_coords}{nx3 numerical vector, the input surface RAS coordinates. Could be the vertex coordinates of an 'fs.surface' instance, or the RAS coords from a surface label.}

\item{talairach}{the 4x4 numerical talairach matrix, or a character string which will be interpreted as the path to an xfm file containing the matrix (typically `$SUBJECTS_DIR/$subject/mri/transforms/talairach.xfm`).}

\item{invert_transform}{logical, whether to invert the transform. Do not use this, call \code{link{talairachras.to.ras}} instead.}
}
\value{
the Talairach RAS coordinates for the given RAS coordinates
}
\description{
Compute MNI talairach coordinates from RAS coords.
}
\note{
You can use this to compute the Talairach coordinate of a voxel, based on its RAS coordinate.
}
