% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mghheader.R
\name{mghheader.scanner2tkreg}
\alias{mghheader.scanner2tkreg}
\title{Compute scanner-RAS 2 tkreg-RAS matrix from basic MGH header fields.}
\usage{
mghheader.scanner2tkreg(header)
}
\arguments{
\item{header}{the MGH header}
}
\value{
4x4 numerical matrix, the transformation matrix
}
\description{
This is also known as the 'scanner2tkreg' matrix. Note that this is a RAS-to-RAS matrix. It is the inverse of the 'tkreg2scanner' matrix, see \code{\link[freesurferformats]{mghheader.tkreg2scanner}}.
}
\examples{
    brain_image = system.file("extdata", "brain.mgz",
                               package = "freesurferformats",
                               mustWork = TRUE);
    vdh = read.fs.mgh(brain_image, with_header = TRUE);
    mghheader.scanner2tkreg(vdh$header);

}
\seealso{
Other header coordinate space: 
\code{\link{mghheader.is.ras.valid}()},
\code{\link{mghheader.ras2vox.tkreg}()},
\code{\link{mghheader.ras2vox}()},
\code{\link{mghheader.tkreg2scanner}()},
\code{\link{mghheader.vox2ras.tkreg}()},
\code{\link{mghheader.vox2ras}()}
}
\concept{header coordinate space}
