% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/construct_subj_dir.R
\name{construct_subj_dir}
\alias{construct_subj_dir}
\title{Construct Subject Directory}
\usage{
construct_subj_dir(label = NULL, mri = NULL, stats = NULL,
  surf = NULL, touch = NULL, subj = NULL,
  subj_root_dir = tempdir())
}
\arguments{
\item{label}{Files to copy to \code{subj_root_dir/subj/label} folder}

\item{mri}{Files to copy to \code{subj_root_dir/subj/mri} folder}

\item{stats}{Files to copy to \code{subj_root_dir/subj/stats} folder}

\item{surf}{Files to copy to \code{subj_root_dir/subj/surf} folder}

\item{touch}{Files to copy to \code{subj_root_dir/subj/touch} folder}

\item{subj}{Name of subject to make folder for to use for Freesurfer functions.
If \code{NULL}, a temporary id will be generated}

\item{subj_root_dir}{Directory to put folder with contents of \code{subj}}
}
\value{
List with the subject name, the SUBJECTS_DIR to use (the directory
that contains the subject name), and the types of objects copied
}
\description{
This function copies files specified by the types of data, 
determined by the folder Freesurfer put them in, into a temporary directory
for easier separation of data and different structuring of data.
}
\examples{
\dontrun{
library(freesurfer)
label = "/Applications/freesurfer/subjects/bert/label/aparc.annot.a2009s.ctab"
mri = c(
  "/Applications/freesurfer/subjects/bert/mri/aparc.a2009s+aseg.mgz",
  "/Applications/freesurfer/subjects/bert/mri/aseg.auto.mgz")
stats = c("/Applications/freesurfer/subjects/bert/stats/lh.aparc.stats",
          "/Applications/freesurfer/subjects/bert/stats/aseg.stats")
surf = "/Applications/freesurfer/subjects/bert/surf/lh.thickness"
touch = NULL
}
}
