% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color.bar.R
\name{color.bar}
\alias{color.bar}
\title{Generate color bar/scale.}
\usage{
color.bar(
  colVal = NULL,
  colBreaks = NULL,
  min = NULL,
  max = NULL,
  lut = NULL,
  nticks = 5,
  ticks = NULL,
  title = NULL
)
}
\arguments{
\item{colVal}{A numeric vector giving the variable values to which each color is corresponding. It overrides \code{min} (and \code{max}) if \code{min > min(colVal)} (\code{max < max(colVal)}).}

\item{colBreaks}{A numeric vector giving the breaks dividing the range of variable into different colors. It overrides \code{min} and \code{max}.}

\item{min}{A scalar giving the minimum value of the variable represented by colors.}

\item{max}{A scalar giving the maximum value of the variable represented by colors.}

\item{lut}{Color vector. Default is \cr
\code{colorRampPalette(colors = c("pink","royalblue"))(length(colBreaks)-1)}.}

\item{nticks}{An integer giving the number of ticks used in the axis of color bar.}

\item{ticks}{A numeric vector giving the locations of ticks used in the axis of color bar; it overrides \code{nticks}.}

\item{title}{A character giving the label of the variable according to which the color bar is generated.}
}
\value{
No return value.
}
\description{
Generate color bar/scale.
}
