% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frailtyEM.R
\docType{package}
\name{frailtyEM-package}
\alias{frailtyEM}
\alias{frailtyEM-package}
\title{frailtyEM: Fitting Frailty Models with the EM Algorithm}
\description{
Contains functions for fitting shared frailty models with a semi-parametric
    baseline hazard with the Expectation-Maximization algorithm. Supported data formats 
    include clustered failures with left truncation and recurrent events in gap-time
    or Andersen-Gill format. Several frailty distributions, such as the the gamma, positive stable
    and the Power Variance Family are supported.
}
\details{
This is an R package for fitting semiparametric shared frailty models with the EM algorithm.
You can check the "issues" section Github (link below)
For the gamma frailty model, the results are identical with those from the survival pacakage,
although frailtyEM provides a more readable output, including confidence intervals for the frailty variance.
Other supported distributions include the PVF, compound Poisson, inverse Gaussian, positive stable.
Univariate and multivariate data with left truncation are supported,
including recurrent events data in Andersen-Gill formulation.

For background on the methods and basic usage of the package, see the paper in the references or the package vignette.
The main fitting function is \code{\link{emfrail}}. For prediction, see \code{\link{predict.emfrail}} and for
plotting, \code{\link{autoplot.emfrail}} (recommended, uses ggplot2) or \code{\link{plot.emfrail}}.
}
\references{
Balan TA, Putter H (2019) "frailtyEM: An R Package for Estimating Semiparametric Shared Frailty Models", \emph{Journal of Statistical Software} \strong{90}(7) 1-29. doi:10.18637/jss.v090.i07
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/tbalan/frailtyEM}
  \item Report bugs at \url{https://github.com/tbalan/frailtyEM/issues}
}

}
\author{
Theodor Balan \email{hello@tbalan.com}
}
\keyword{internal}
