% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GTS2020_scale.R
\name{GTS2020_scale}
\alias{GTS2020_scale}
\title{GTS2020_scale}
\usage{
GTS2020_scale(
  x,
  srt = "early_interval",
  end = "late_interval",
  max_ma = NULL,
  min_ma = NULL,
  verbose = TRUE
)
}
\arguments{
\item{x}{A data.frame containing, minimally two columns
corresponding respectively to the first and last intervals
of the data. Missing values in the second column will be
infilled using the corresponding value in the second column
following PBDB formatting where only the first interval
column is recorded when a datapoint lies solely within that
interval.}

\item{srt}{A character of length 1 specifing the column name
of the first interval field in x}

\item{end}{A character of length 1 specifing the column name
of the last interval field in x}

\item{max_ma}{If not NULL, a character of length 1 specifing
the column name of the original numeric maximum age field in
x, to be used as fall back values if interval names cannot
all be matched}

\item{min_ma}{If not NULL, a character of length 1 specifing
the column name of the original numeric minimum age field in
x, to be used as fall back values if interval names cannot
all be matched}

\item{verbose}{A logical indicating if warning messages should be
displayed or otherwise}
}
\value{
The dataframe, x, with two additional columns containing
the revised first and last numeric ages of the data, with column
names GTS_FAD and GTS_LAD respectively
}
\description{
Convenience function to apply GTS2020 chronostratigraphy
to fossil datasets. The function relies on a lookup table
generated based on the named intervals in the PBDB in early
2021. First and last interval names in the supplied dataset
are matched against this lookup table, itself available
using 'get("GTS2020)", to get GTS2020 numeric ages. If the
dataset contains intervals which are not present in the
lookup table, they will not be matched and the user will
be warned. To get around this possibility, the user can
also supply the original numeric ages which will be used
as default ages if an interval cannot be matched, to ensure
that the returned vectors of numeric ages do not contain NAs.
}
\examples{
# example dataset
data("brachios")
# add GTS 2020 dates
brachios <- GTS2020_scale(brachios, srt = "early_interval", end = "late_interval",
                          max_ma = "max_ma", min_ma = "min_ma")
}
