% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expectedLR.R
\name{expectedLR}
\alias{expectedLR}
\title{Expected likelihood ratio}
\usage{
expectedLR(numeratorPed, denominatorPed, truePed = numeratorPed, ids, marker)
}
\arguments{
\item{numeratorPed}{A \code{ped} object.}

\item{denominatorPed}{A \code{ped} object.}

\item{truePed}{A \code{ped} object.}

\item{ids}{A vector of ID labels corresponding to untyped pedigree members.
(These must be members of all three input pedigrees).}

\item{marker}{either a marker object compatible with \code{numeratorPed}, or the
name or index of a marker attached to \code{numeratorPed}.}
}
\value{
A positive number.
}
\description{
This function computes the expected LR for a single marker, in a kinship test
comparing two hypothesised relationships between a set of individuals. The
true relationship may differ from both hypotheses. Some individuals may
already be genotyped, while others are available for typing. The
implementation uses \code{oneMarkerDistribution()} to find the joint genotype
distribution for the available individuals, conditional on the known data, in
each pedigree.
}
\examples{

#---------
# Curious example showing that ELR may decrease
# by typing additional reference individuals
#---------

# Numerator ped
numPed = nuclearPed(father = "fa", mother = "mo", child = "ch")

# Denominator ped: fa, mo, ch are unrelated. (Hack!)
denomPed = halfSibPed() |> relabel(old = 1:3, new = c("mo", "fa", "ch"))

# Scenario 1: Only mother is typed; genotype 1/2
p = 0.9
m1 = marker(numPed, mo = "1/2", afreq = c("1" = p, "2" = 1-p))
expectedLR(numPed, denomPed, ids = "ch", marker = m1)

1/(8*p*(1-p)) + 1/2 # exact formula

# Scenario 2: Include father, with genotype 1/1
m2 = m1
genotype(m2, id = "fa") = "1/1"
expectedLR(numPed, denomPed, ids = "ch", marker = m2)

1/(8*p*(1-p)) + 1/(4*p^2) # exact formula

}
