% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.one.sided.R, R/is.two.sided.R
\docType{methods}
\name{is.one.sided}
\alias{is.one.sided}
\alias{is.one.sided,formula-method}
\alias{is.one.sided,call-method}
\alias{is.one.sided,<--method}
\alias{is.one.sided,expression-method}
\alias{is.one.sided,list-method}
\alias{is.one.sided,ANY-method}
\alias{is.two.sided}
\alias{is.two.sided,formula-method}
\alias{is.two.sided,call-method}
\alias{is.two.sided,<--method}
\alias{is.two.sided,expression-method}
\alias{is.two.sided,list-method}
\alias{is.two.sided,ANY-method}
\title{Determine if an object is one- or two-sided.
 
Test whether a object (typically formula, call or expression) is one- (e.g. 
\code{~x}) or two-sided (e.g. \code{x~y}).}
\usage{
is.one.sided(x, ...)

\S4method{is.one.sided}{formula}(x, ...)

\S4method{is.one.sided}{call}(x, ...)



\S4method{is.one.sided}{expression}(x, ...)

\S4method{is.one.sided}{list}(x, ...)

\S4method{is.one.sided}{ANY}(x, ...)

is.two.sided(x, ...)

\S4method{is.two.sided}{formula}(x, ...)

\S4method{is.two.sided}{call}(x, ...)



\S4method{is.two.sided}{expression}(x, ...)

\S4method{is.two.sided}{list}(x, ...)

\S4method{is.two.sided}{ANY}(x, ...)
}
\arguments{
\item{x}{object to test for one-sidedness.}

\item{...}{arguments passed to called functions}
}
\value{
logical; whether \code{x} is an object is one-sided or two-sided formula.
}
\description{
Determine if an object is one- or two-sided.
 
Test whether a object (typically formula, call or expression) is one- (e.g. 
\code{~x}) or two-sided (e.g. \code{x~y}).
}
\details{
These functions detect whether the formula is single- (unary) or double-
sided. They work on formulas, expression, calls, assignments, etc.

\code{is.single.sided} and \code{is.unary} are alias for 
\code{is.single.sided}. \code{is.double.sided} and \code{is.binary} are 
aliases for \code{is.two.sided}.
}
\note{
Methods for the "\code{<-}" class exist and are not included in the usage 
documentation because CRAN does not support S4 documentation for this class.
}
\examples{

form <- y ~ x 

is.one.sided(form)
# is.single.sided(form)
# is.unary(form) 

is.two.sided(form)
# is.double.sided(form)
# is.binary(form)
                
}
