% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FG_Server.R
\name{FG_Server}
\alias{FG_Server}
\title{Figure Generation Server}
\usage{
FG_Server(
  id,
  FM_yaml_file = system.file(package = "formods", "templates", "formods.yaml"),
  MOD_yaml_file = system.file(package = "formods", "templates", "FG.yaml"),
  id_ASM = "ASM",
  id_UD = "UD",
  id_DW = "DW",
  deployed = FALSE,
  react_state = NULL
)
}
\arguments{
\item{id}{An ID string that corresponds with the ID used to call the module's UI function}

\item{FM_yaml_file}{App configuration file with FM as main section.}

\item{MOD_yaml_file}{Module configuration file with MC as main section.}

\item{id_ASM}{ID string for the app state management module used to save and load app states}

\item{id_UD}{ID string for the upload data module used to handle uploads or the name of the list element in react_state where the data set is stored.}

\item{id_DW}{ID string for the data wrangling module to process any uploaded data}

\item{deployed}{Boolean variable indicating whether the app is deployed or not.}

\item{react_state}{Variable passed to server to allow reaction outside of module (\code{NULL})}
}
\value{
FG Server object
}
\description{
Server function for the figure generation module
}
\examples{
if(interactive()){
# These are suggested packages
library(shinydashboard)
library(ggpubr)
library(plotly)
library(shinybusy)
library(prompter)
library(utils)
library(clipr)
library(formods)

CSS <- "
.wrapfig {
  float: right;
  shape-margin: 20px;
  margin-right: 20px;
  margin-bottom: 20px;
}
"

# Default to not deployed
if(!exists("deployed")){
  deployed = FALSE
}

#https://fontawesome.com/icons?from=io
data_url =
"https://github.com/john-harrold/formods/raw/master/inst/test_data/TEST_DATA.xlsx"

ui <- dashboardPage(
  skin="black",
  dashboardHeader(title="formods"),
  dashboardSidebar(
     sidebarMenu(
       menuItem("Source Data",     tabName="upload",      icon=icon("table")) ,
       menuItem("Wrangle",         tabName="wrangle",     icon=icon("hat-cowboy")),
       menuItem("Plot",            tabName="plot",        icon=icon("chart-line")),
       menuItem("App State",       tabName="app_state",   icon=icon("archive")),
       menuItem("App Info",        tabName="sysinfo",     icon=icon("book-medical"))
     )
  ),
  dashboardBody(
  tags$head(
    tags$style(HTML(CSS))
  ),
    tabItems(
       tabItem(tabName="app_state",
                 box(title="Manage App State",
                     htmlOutput(NS("ASM", "ui_asm_compact")))),
       tabItem(tabName="upload",
               box(title="Load Data", width=12,
                 fluidRow(
                   prompter::use_prompt(),
                   column(width=6,
                     htmlOutput(NS("UD",  "UD_ui_compact"))),
                   column(width=6,
       tags$p(
           tags$img(
           class = "wrapfig",
           src   = "https://github.com/john-harrold/formods/raw/master/man/figures/logo.png",
           width = 100,
           alt = "formods logo" ),
         'Formods is a set of modules and an framework for developing modules
         which interact and create code to replicate analyses performed within an app.
         To experiment download this',
       tags$a("test dataset", href=data_url),
              'and upload it into the App using the form on the left.'))
                 )
               )
               ),
       tabItem(tabName="wrangle",
               box(title="Transform and Create Views of Your Data", width=12,
               htmlOutput(NS("DW",  "DW_ui_compact")))),
       tabItem(tabName="plot",
               box(title="Visualize Data", width=12,
               htmlOutput(NS("FG",  "FG_ui_compact")))),
       tabItem(tabName="sysinfo",
               box(title="System Details", width=12,
               shinydashboard::tabBox(
                 width = 12,
                 title = NULL,
                 shiny::tabPanel(id="sys_details",
                          title=tagList(shiny::icon("ghost"),
                                        "Deployment Details"),
                 htmlOutput(NS("ASM", "ui_asm_sys_detials"))
                 ),
                 shiny::tabPanel(id="sys_log",
                          title=tagList(shiny::icon("clipboard-list"),
                                        "App Log"),
                 verbatimTextOutput(NS("ASM", "ui_asm_sys_log"))
                 )
                 )
               ))
      )
    )
  )

# Main app server
server <- function(input, output, session) {
  # Empty reactive object to track and react to
  # changes in the module state outside of the module
  react_FM = reactiveValues()

  # This is the list of module ids used for reproducible script generation. The
  # order here is important.
  mod_ids = c("UD", "DW", "FG")

  #Populating with test data
  #FG_test_mksession(session)
  # Module servers
  formods::ASM_Server(id="ASM",
             deployed    = deployed,
             react_state = react_FM, mod_ids = mod_ids)
  formods::UD_Server( id="UD", id_ASM = "ASM",
             deployed    = deployed,
             react_state = react_FM)
  formods::DW_Server( id="DW", id_ASM = "ASM",id_UD = "UD",
             deployed    = deployed,
             react_state = react_FM)
  formods::FG_Server( id="FG", id_ASM = "ASM",id_UD = "UD", id_DW = "DW",
             deployed    = deployed,
             react_state = react_FM)
}

shinyApp(ui, server)
}
}
