% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tostring.R
\name{wrap_string}
\alias{wrap_string}
\alias{wrap_txt}
\title{Wrap a string to within a precise width}
\usage{
wrap_string(str, width, collapse = NULL)

wrap_txt(str, width, collapse = NULL)
}
\arguments{
\item{str}{character. String to be wrapped. If it is a character vector or
a list, it will be looped as a list and returned with \code{unlist(use.names = FALSE)}.}

\item{width}{numeric(1). Width, in characters, that the
text should be wrapped at.}

\item{collapse}{character(1) or \code{NULL}. If the words that have been split should
be pasted together with the collapse character. This is usually done internally
with \code{"\\n"} to have the wrapping updated along with other internal values.}
}
\value{
A string if \code{str} is one element and if \code{collapse = NULL}. Otherwise, is
a list of elements (if \code{length(str) > 1}) that can contain strings or vector of
characters (if \code{collapse = NULL}).
}
\description{
Core wrapping functionality that preserve white spaces. Only \code{"\\n"} is not supported
by core functionality \code{\link[stringi:stri_wrap]{stringi::stri_wrap()}}. This is usually solved before hand by
\code{\link[=matrix_form]{matrix_form()}}. If the width is smaller than any large word, these will be truncated
after \code{width} characters. If the split leaves trailing groups of empty spaces,
they will be dropped.
}
\details{
Word wrapping happens as with \code{\link[stringi:stri_wrap]{stringi::stri_wrap()}}
with the following exception: individual words which are longer
than \code{max_width} are broken up in a way that fits with the rest of the
word wrapping.
}
\section{Functions}{
\itemize{
\item \code{wrap_txt()}: function that flattens the list of wrapped strings with
\code{unist(str, use.names = FALSE)}. This is deprecated, use \code{\link[=wrap_string]{wrap_string()}} instead.

}}
\examples{
str <- list(
  "  , something really  \\\\tnot  very good", # \t needs to be escaped
  "  but I keep it12   "
)
wrap_string(str, 5, collapse = "\n")

wrap_txt(str, 5, collapse = NULL)

}
