% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTicks.R
\name{getTicks}
\alias{getTicks}
\title{Ticks for plot axis}
\usage{
getTicks(low, high = low, clip = c(-Inf, Inf), exp = FALSE, digits = 0)
}
\arguments{
\item{low}{lower bound, can be a single number or a vector}

\item{high}{upper bound - optional, you can just have all data in the low variable}

\item{clip}{if the ci are clipped}

\item{exp}{If the value should be in exponential form (default)}

\item{digits}{Number of digits - used in exp mode}
}
\value{
\code{vector} Returns a vector with the ticks
}
\description{
Gets the ticks in a formatted version. This is since I'm not always
that fond of just pretty(1:10/5). In exponential form the ticks are
determined from the 2-base, meaning that you get an intuitive feeling
for when the value is doubled.
}
\details{
This function is far from perfect and I recommend specifying yourself
the ticks that you want.
}
\examples{
test_data <- data.frame(coef=c(2, 0.5),
  low=c(1.5, 0.05),
  high=c(3, 0.75),
  boxsize=c(0.5, 0.5))

# Exponential form where the exponent base i 2 for easier understanding
getTicks(low = test_data$low, 
  high = test_data$high, 
  clip=c(-Inf, Inf), 
  exp=TRUE)

# Non exponential form with using pretty
getTicks(low = test_data$low, 
  high = test_data$high, 
  clip=c(-Inf, Inf), 
  exp=FALSE)


# A very simple example
getTicks(1:5*2.33, 
  exp=FALSE)

# A slightly more advanced exponential version
getTicks(1:10*.33, 
  digits=2,
  exp=TRUE)
}

