% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forest_structure.R
\name{forest_structure}
\alias{forest_structure}
\title{Get the forest horizontal, vertical and internal structure}
\usage{
forest_structure(df, species, dbh, plot, plot_area, vertical_est = NA,
  internal_est = NA, NI_label = "")
}
\arguments{
\item{df}{A data frame.}

\item{species}{Quoted name of the scientific names variable, or any variable used to differentiate the different species found in data.}

\item{dbh}{Quoted name of the diameter at breast height variable, in cm.}

\item{plot}{Quoted name of the plot variable. used to differentiate the plot's trees, and calculate the number of sampled plots.}

\item{plot_area}{Quoted name of the plot area variable, or a numeric vector with the plot area value. The plot area value must be in square meters.}

\item{vertical_est}{Optional argument. Quoted name of the vertical strata variable, or the height variable. If this is a factor variable, it's levels will be used to classify the forest vertically. If it's a height variable, the vertical strata will be created based on it's mean and standard deviation values. Default: \code{NA}.}

\item{internal_est}{Optional argument. Quoted name of the internal strata variable. Default: \code{NA}.}

\item{NI_label}{Label used for Species not identified. This parameter works along with species. The level supplied here will not be considered in the classification. Default \code{""}.}
}
\value{
a data frame with the forest's structure.
}
\description{
This function calculates the horizontal structure of a given forest inventory data,
with information like absolute frequency, relative frequency, absolute density,
relative density, absolute dominance, relative dominance, importance value index, and coverage
value index. If additional variables are supplied, the vertical and internal structures are
also provided.
}
\examples{
library(forestmangr)
data("exfm20")
exfm20

# Get the forest's horizontal structure:
forest_structure(exfm20, "scientific.name", "dbh", "transect", 10000)

# area plot as a variable name:
forest_structure(exfm20, "scientific.name", "dbh", "transect", "plot.area") 

# Get the forest's horizontal and vertical structure.
# The vertical structure variable can either be the height variable,
# or a factor variable with the horizontal strata:
forest_structure(exfm20, "scientific.name", "dbh", "transect", 10000, "canopy.pos") 

# Get the forest's horizontal, vertical and internal structure:
forest_structure(exfm20, "scientific.name", "dbh", "transect", 10000, "canopy.pos", "light") 

}
\references{
Souza, A. L. and Soares, C. P. B. (2013) Florestas Nativas: estrutura, dinamica e manejo. Vicosa: UFV.
}
\author{
Eric Bastos Gorgens \email{e.gorgens@gmail.com}
}
