% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/land-cover.R
\name{fd_landcover_esri}
\alias{fd_landcover_esri}
\title{Download data from the ESRI Land Cover Explorer}
\usage{
fd_landcover_esri(utm_code, year, quiet = TRUE)
}
\arguments{
\item{utm_code}{a character string of length 1 with an UTM code (e.g. "29N")}

\item{year}{an integer or vector of integers corresponding to the base year
of the land cover tile. The option \code{year = 'all'} downloads all
the available images (2017:2023)}

\item{quiet}{if \code{TRUE} (the default), suppress status messages, and
the progress bar}
}
\value{
A \code{SpatRaster}
}
\description{
Download an UTM tile of the ESRI Land Cover Explorer for a specified year
}
\examples{
\donttest{
# Download Land Cover for UTM tile 29N year 2023
lc <- fd_landcover_esri("29N", year = 2023)

# Download Land Cover for UTM time 29N for all years
lc <- fd_landcover_esri("29N", year = "all")
}
}
\references{
\url{https://livingatlas.arcgis.com/en/home/}
}
