% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mspe.R
\name{MSPE}
\alias{MSPE}
\title{Mean squared \eqn{h}-step ahead prediction errors}
\usage{
MSPE(X, predcoef, m1 = length(X)/10, m2 = length(X), P = 1, H = 1,
  N = c(0, seq(P + 1, m1 - H + 1)))
}
\arguments{
\item{X}{the data \eqn{X_1, \ldots, X_T}}

\item{predcoef}{the prediction coefficients in form of a list of an array
         \code{coef}, and two integer vectors \code{t}    and \code{N}. The two
       integer vectors provide the information for which indices \eqn{t} and
         segment lengths \eqn{N} the coefficients are to be interpreted;
\code{(m1-H):(m2-1)} has to be a subset of \code{predcoef$t}.
         if not provided the necessary coefficients will be computed using
         \code{\link{predCoef}}.}

\item{m1}{first index from the set in which the indices \eqn{t+h} shall lie}

\item{m2}{last index from the set in which the indices \eqn{t+h} shall lie}

\item{P}{maximum order of prediction coefficients to be used;
must not be larger than \code{dim(predcoef$coef)[1]}.}

\item{H}{maximum lead time to be used;
must not be larger than \code{dim(predcoef$coef)[3]}.}

\item{N}{vector with the segment sizes to be used, 0 corresponds to
           using 1, ..., t;
has to be a subset of predcoef$N.}
}
\value{
Returns an object of type \code{MSPE} that has \code{mspe}, an array
        of size \code{H}\eqn{\times}\code{P}\eqn{\times}\code{length(N)},
        as an attribute, as well as the parameters \code{N}, \code{m1},
        \code{m2}, \code{P}, and \code{H}.
}
\description{
This function computes the empirical mean squared prediction errors for
a collection of \eqn{h}-step ahead, linear predictors (\eqn{h=1,\ldots,H})
of observations \eqn{X_{t+h}}, where \eqn{m_1 \leq t+h \leq m_2}, for two
indices \eqn{m_1} and \eqn{m_2}. The resulting array provides
\deqn{\frac{1}{m_2 - m_1 + 1} \sum_{t=m_1-h+1}^{m_2 - h} (X_{t+h} - (X_t, \ldots, X_{t-p+1}) \hat v_{N,T}^{(p,h)}(t) )^2.}
for every \eqn{h=1,..,}\code{H}, \eqn{p=1,..,}\code{P}, and \eqn{N \in}\code{N}.
}
\examples{
T <- 1000
X <- rnorm(T)
P <- 5
H <- 1
m <- 20
Nmin <- 20
pcoef <- predCoef(X, P, H, (T - m - H + 1):T, c(0, seq(Nmin, T - m - H, 1)))

mspe <- MSPE(X, pcoef, 991, 1000, 3, 1, c(0, Nmin:(T-m-H)))

plot(mspe, vr = 1, Nmin = Nmin)
}

