% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_windows.R
\name{create_windows}
\alias{create_windows}
\title{Create time-contiguous validation datasets for model evaluation}
\usage{
create_windows(lagged_df, window_length = 12L, window_start = NULL,
  window_stop = NULL, skip = 0, include_partial_window = TRUE)
}
\arguments{
\item{lagged_df}{An object of class 'lagged_df' or 'grouped_lagged_df' from \code{\link{create_lagged_df}}.}

\item{window_length}{An integer that defines the length of the contiguous validation dataset in dataset rows/dates.
If dates were given in \code{create_lagged_df()}, the validation window is 'window_length' * 'date frequency' in calendar time.
Setting \code{window_length = 0} trains the model on (a) the entire dataset or (b) between a single \code{window_start} and
\code{window_stop} value. Specifying multiple \code{window_start} and \code{window_stop} values with vectors of
length > 1 overrides \code{window_length}.}

\item{window_start}{Optional. A row index or date identifying the row/date to start creating contiguous validation datasets. A
vector of start rows/dates can be supplied for greater control. The length and order of \code{window_start} should match \code{window_stop}.
If \code{length(window_start) > 1}, \code{window_length}, \code{skip}, and \code{include_partial_window} are ignored.}

\item{window_stop}{Optional. An index or date identifying the row/date to stop creating contiguous validation datasets. A
vector of start rows/dates can be supplied for greater control. The length and order of \code{window_stop} should match \code{window_start}.
If \code{length(window_stop) > 1}, \code{window_length}, \code{skip}, and \code{include_partial_window} are ignored.}

\item{skip}{An integer giving a fixed number of dataset rows/dates to skip between validation datasets. If dates were given
in \code{create_lagged_df()}, the time between validation windows is \code{skip} * 'date frequency'.}

\item{include_partial_window}{Boolean. If \code{TRUE}, keep validation datasets that are shorter than \code{window_length}.}
}
\value{
An S3 object of class 'windows': A data.frame giving the indices for the validation datasets.
}
\description{
Flexibly ceate blocks of time-contiguous validation datasets to assess forecast accuracy
of trained models at various times in the past. These validation datasets are similar to
the outer loop of a nested cross-validation model training setup.
}
\section{Methods and related functions}{


The output of \code{create_windows()} is passed into

\itemize{
  \item \code{\link{train_model}}
}

and has the following generic S3 methods

\itemize{
  \item \code{\link[=plot.windows]{plot}}
}
}

\examples{
# Sampled Seatbelts data from the R package datasets.
data("data_seatbelts", package = "forecastML")

# Example - Training data for 2 horizon-specific models w/ common lags per feature.
horizons <- c(1, 12)
lookback <- 1:15

data_train <- create_lagged_df(data_seatbelts, type = "train", outcome_col = 1,
                               lookback = lookback, horizon = horizons)

# All historical window lengths of 12 plus any partial windows at the end of the dataset.
windows <- create_windows(data_train, window_length = 12)
windows

# Two custom validation windows with different lengths.
windows <- create_windows(data_train, window_start = c(20, 80), window_stop = c(30, 100))
windows
}
