% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relevel.R
\name{fct_relevel}
\alias{fct_relevel}
\title{Change the order of levels in a factor}
\usage{
fct_relevel(f, ...)
}
\arguments{
\item{f}{A factor.}

\item{...}{Character vector of levels. Any levels not mentioned will be
left in existing order, after the explicitly mentioned levels.}
}
\description{
This is a generalisaton of \code{\link[stats]{relevel}} that allows you to
move any number of levels to the front.
}
\examples{
f <- factor(c("a", "b", "c"))
fct_relevel(f)
fct_relevel(f, "c")
fct_relevel(f, "b", "a")

# You'll get a warning if the levels don't exist
fct_relevel(f, "d")
}

