% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foodweb.R
\name{foodwebWrapper}
\alias{foodwebWrapper}
\title{foodwebWrapper}
\usage{
foodwebWrapper(
  funs,
  where = character(0),
  prune = character(0),
  rprune,
  ancestors = TRUE,
  descendents = TRUE,
  ofile = "~/foodwebWrapper.html",
  zeros = TRUE,
  pawn = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{funs}{character vector OR (in foodweb only) the result of a previous foodweb call}

\item{where}{position(s) on search path, or an environment, or a list of environments}

\item{prune}{character vector. If omitted, all funs will be shown; otherwise, only ancestors and descendants of functions in prune will be shown. Augments funs if required.}

\item{rprune}{regexpr version of prune; prune <- funs \%matching\% rprune. Does NOT augment funs. Overrides prune if set.}

\item{ancestors}{show ancestors of prune functions?}

\item{descendents}{show descendents of prune functions?}

\item{ofile}{character string containing path name for output file}

\item{zeros}{Boolean if TRUE delete rows and cols that contain all 0's}

\item{pawn}{Boolean if TRUE use chess symbols rather than rectangles in html table}

\item{verbose}{Boolean if TRUE output several user messages}
}
\value{
foodweb returns an object of (S3) class foodweb. This has three components:
\itemize{
\item funmat a matrix of 0s and 1s showing what (row) calls what (column). The dimnames are the function names.
\item x shows the x-axis location of the centre of each function's name in the display, in par("usr") units
\item level shows the y-axis location of the centre of each function's name in the display, in par("usr") units. For small numbers of functions, this will be an integer; for larger numbers, there will some adjustment around the nearest integer
}
}
\description{
wrapper for the function foodweb()
concatenate the R package name for each retrieved R function
}
\details{
If where=0, then the user is presented with the option
of choosing from a list of attached packages

Many examples are given in the documentation for foodweb()
}
\examples{

if(interactive()){
  foodwebWrapper(where=0,prune="cbind",
  ofile=sprintf("\%s/foodwebWrapper.html",tempdir()))
  }

}
