% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_cat_bin.R
\name{boot_cat_bin}
\alias{boot_cat_bin}
\title{Bootstrap inference on binary and categorical variables}
\usage{
boot_cat_bin(obs_data, list_cat_var, list_bin_var, threshold_bin,
  threshold_cat, threshold_bin_cat, method = c("mi", "mic"),
  boots = 5000, show_progress = TRUE)
}
\arguments{
\item{obs_data}{(data.frame or matrix) : a dataset which rows are
observations and columns the variables.}

\item{list_cat_var}{: list of the categorical variables of the dataset}

\item{list_bin_var}{: list of the binary variables of the dataset}

\item{threshold_bin}{: the threshold to apply to binary pairwise
associations}

\item{threshold_cat}{: the threshold to apply to categorical pairwise
associations}

\item{threshold_bin_cat}{: to apply to a pairwise association between
a binary and a categorical variable}

\item{method}{: the method to use to compute the adjacency matrix
("mi" or "mic").
If "mi", uses mutual information package \code{minet},
and Miller-Madow estimator.
If "mic", uses maximal information coefficient from \code{minerva}
package function \code{cstats()}}

\item{boots}{: number of bootstraps (default 5000)}

\item{show_progress}{: if TRUE, prints the percentage of completion to
keep track of the algorithm's progress.
Default is TRUE. Recommended to FALSE for RMarkdown files.}
}
\value{
The inferred adjacency matrix. All bootstrap 1th percentile
values of each pairwise association
inferior to their predefined thresholds will be set to 0.
}
\description{
For a given dataset, performs a confidence-interval bootstrap of
the mutual information or maximal information coefficient (MIC)
for each pairwise association.
\enumerate{
  \item Computes the MI or MIC for each pairwise association.
  \item Performs a bootstrap (of \code{boots} samples), and store
  each pairwise association
  \item Calculate the 1th percentile for each pairwise association
  from the bootstrap distribution
  \item If the percentile is inferior to the threshold of the
  corresponding pairwise variable type, then the MI or MIC is set to 0.
}
}
