% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isotopes.R
\docType{data}
\name{vegetation}
\alias{vegetation}
\title{\eqn{\delta^{13}C}{\delta13C} Values for Vegetation}
\format{
A \code{data.frame} with 155 observations and 5 variables:
\describe{
\item{family}{\code{\link{character}}: plant family.}
\item{species}{\code{\link{character}}: plant species.}
\item{type}{\code{\link{character}}: C3 or C4 plant.}
\item{delta}{\code{\link{numeric}}: isotopic ratio \eqn{\delta^{13}C}{\delta13C}
(per mil).}
\item{country}{\code{\link{character}}: country.}
}
}
\source{
Cerling, T. E. and Harris, J. M. (1999). Carbon isotope fractionation
between diet and bioapatite in ungulate mammals and implications for
ecological and paleoecological studies. \emph{Oecologia}, 120, 347-363.
\doi{10.1007/s004420050868}
}
\usage{
vegetation
}
\description{
\eqn{\delta^{13}C}{\delta13C} Values for Vegetation
}
\examples{
hist(
  x = vegetation$delta,
  breaks = 20,
  main = "C3 and C4 plants",
  xlab = expression(delta^{13}*"C"),
  xlim = c(-40, 0)
 )

boxplot(
  delta ~ type,
  data = vegetation,
  horizontal = TRUE,
  xlab = expression(delta^{13}*"C"),
  ylab = "Plant",
  ylim = c(-40, 0)
)
}
\seealso{
Other isotopic data: 
\code{\link{lisiecki2005}},
\code{\link{ngrip2004}},
\code{\link{ngrip2010}},
\code{\link{nydal1996}},
\code{\link{spratt2016}}
}
\concept{isotopic data}
\keyword{datasets}
