% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MaP.R
\name{MaP}
\alias{MaP}
\title{Maximum a Posteriori clustering}
\usage{
MaP(x, dist, ...)
}
\arguments{
\item{x}{\link[base]{numeric} \link[base]{vector}}

\item{dist}{an \linkS4class{fmx} object}

\item{...}{..}
}
\value{
Function \link{MaP} returns an \link[base]{integer} \link[base]{vector}.
}
\description{
..
}
\examples{
x = rnorm(1e2L, sd = 2)
m = fmx('norm', mean = c(-1.5, 1.5), w = c(1, 2))
library(ggplot2)
ggplot() + geom_function(fun = dfmx, args = list(dist = m)) + 
  geom_point(mapping = aes(x = x, y = .05, color = factor(MaP(x, dist = m)))) + 
  labs(color = 'Maximum a Posteriori\nClustering')

}
