% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.fmx.R
\name{as.fmx.mixEM}
\alias{as.fmx.mixEM}
\title{Convert \code{mixEM} Objects to \linkS4class{fmx} Class}
\usage{
\method{as.fmx}{mixEM}(x, data = x[["x"]], ...)
}
\arguments{
\item{x}{\code{mixEM} object}

\item{data}{\link[base]{numeric} \link[base]{vector}}

\item{...}{..}
}
\value{
Function \link{as.fmx.mixEM} returns an \linkS4class{fmx} object.
}
\description{
To convert \code{mixEM} objects (from package \CRANpkg{mixtools})
to \linkS4class{fmx} class.

Currently only the returned value of
\link[mixtools]{normalmixEM} and \link[mixtools]{gammamixEM} are supported
}
\note{
\link[mixtools]{plot.mixEM} not plot \link[mixtools]{gammamixEM} returns, as of 2022-09-19.
}
\examples{
library(mixtools)
(wait = as.fmx(normalmixEM(faithful$waiting, k = 2)))
hist.default(faithful$waiting, freq = FALSE)
curve(dfmx(x, dist = wait), xlim = range(faithful$waiting), add = TRUE)

}
