% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fdata.R
\name{fdata}
\alias{fdata}
\title{Format a data frame or tibble}
\usage{
fdata(x, ...)
}
\arguments{
\item{x}{A data frame or tibble to be formatted.}

\item{...}{Any follow-on parameters to the format function.}
}
\value{
A new, formatted data frame or tibble with the formats applied.
}
\description{
The \code{fdata} function applies formatting attributes
to the entire data frame.
}
\details{
If formats are assigned to the "format" attributes of the data frame
columns, the \code{fdata} function will apply those formats
to the specified columns, and return a new, formatted data frame. 
Formats can be specified as formatting strings, named vectors, user-defined
formats, or vectorized formatting functions.  The \code{fdata} 
function will
apply the format to the associated column data using the \code{fapply} 
function. A format can also be specified as a formatting list of the 
previous four types.  See the \code{\link{fapply}}
function for additional information.

After formatting each column, the \code{fdata} function will 
call the base R \code{\link{format}} function on 
the data frame.  Any follow on parameters will be sent to the \code{format}
function.
}
\examples{
## Example 1: Simple Formats ##
# Set up data frame
df <- mtcars[1:10, c("mpg", "cyl")]
df

# Define and assign formats
formats(df) <- list( mpg = value(condition(x >= 20, "High"),
                                condition(x < 20, "Low")),
                     cyl = value(condition(x == 4, "Small"),
                                condition(x == 6, "Midsize"),
                                condition(x == 8, "Large")))
              
# Apply formatting
fdata(df)

## Example 2: Formatting List ##
# Set up data
v1 <- c("num", "char", "date", "char", "date", "num")
v2 <- list(1.258, "H", Sys.Date(),
           "L", Sys.Date() + 60, 2.8865)

df <- data.frame(type = v1, values = I(v2))
df

# Create formatting list
lst <- flist(type = "row", lookup = v1, 
             num = "\%.1f",
             char = value(condition(x == "H", "High"),
                          condition(x == "L", "Low"),
                          condition(TRUE, "NA")),
             date = "\%d\%b\%y")

# Assign list and lookup to column attributes
df$values <- fattr(df$values, format = lst)

# Apply formatting list
fdata(df)
}
\seealso{
\code{\link{fapply}} to apply a format to a vector,
\code{\link{value}} to define a format object,
\code{\link{fattr}} to assign formatting specifications to a single 
column/vector, and the
\code{\link{formats}}, \code{\link{widths}}, and \code{\link{justification}}
functions to get or set formatting for an entire data frame.  Also see
\link{FormattingStrings} for documentation on formatting strings.
}
