% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marketInfo.R
\name{fmpc_symbols_by_market}
\alias{fmpc_symbols_by_market}
\title{Get available symbols across markets}
\usage{
fmpc_symbols_by_market(market = "all")
}
\arguments{
\item{market}{select one or more markets to pull available symbols. options
include: 'all', 'etf', 'commodity', 'euronext', 'nyse',' amex', 'tsx',
'index', 'mutual_fund', 'nasdaq', 'crypto', 'forex'}
}
\value{
a data frame of pricing, split, and dividend history
}
\description{
Pulls all symbols available on FMP Cloud that has historical pricing data.
Markets can include equities, mutual funds, commodities, indexes, and more.
}
\section{Warning}{
 Running 'all' generates 11 API calls
}

\examples{

\dontrun{

# A valid token must be set to use this function
fmpc_set_token('FMPAPIKEY')
fmpc_symbols_by_market(market = c('index','commodity'))
fmpc_symbols_by_market() # default will pull all markets

}
}
