% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/financials.R
\name{fmpc_financial_bs_is_cf}
\alias{fmpc_financial_bs_is_cf}
\title{Get financial data for one or more tickers}
\usage{
fmpc_financial_bs_is_cf(
  symbols = "AAPL",
  statement = c("income", "balance", "cashflow"),
  quarterly = TRUE,
  growth = FALSE,
  SECReported = FALSE,
  limit = 100
)
}
\arguments{
\item{symbols}{one or more publicly traded companies domestic or
international}

\item{statement}{indicate the statement to view. Can be 'income', 'balance',
or 'cashflow'}

\item{quarterly}{TRUE/FALSE whether the statement should be shown quarterly
or annually}

\item{growth}{TRUE/FALSE whether the growth statement should be shown}

\item{SECReported}{TRUE/FALSE whether to display the information as it was
reported to the SEC. Only one symbol can be passed if this is set to TRUE.
Growth must also be set to FALSE. International stocks should not be
passed.}

\item{limit}{limit the result for each ticker}
}
\value{
returns balance sheet, income statement, or cash flow
}
\description{
Pull balance sheet, income statement, or cash flow statement for one or more
tickers. Can elect to see data quarterly or annually and view growth
}
\examples{


\dontrun{

# Setting API key to 'demo' allows for AAPL only
fmpc_set_token()
fmpc_financial_bs_is_cf()
fmpc_financial_bs_is_cf('AAPL',statement = 'balance', quarterly = FALSE,
                     growth = FALSE, SECReported = TRUE, limit = 10)


# Must set a valid API token
fmpc_set_token('FMPAPIKEY')
fmpc_financial_bs_is_cf(c('AAPL','MSFT','TSLA'))

 symbols = c('AAPL','MSFT','BAC')
 Bal = fmpc_financial_bs_is_cf(symbols,statement = 'balance')
 BalG = fmpc_financial_bs_is_cf(symbols,statement = 'balance', growth = FALSE)
 IS = fmpc_financial_bs_is_cf(symbols,statement = 'income')
 ISa = fmpc_financial_bs_is_cf(symbols,statement = 'income', quarterly = FALSE)
 cf = fmpc_financial_bs_is_cf(symbols,statement = 'cashflow')
 cfsec = fmpc_financial_bs_is_cf(symbols,statement = 'cashflow', SECReported  = TRUE)

# International tickers work
fmpc_financial_bs_is_cf('RY.TO',statement = 'balance', quarterly = TRUE,
                     growth = TRUE, SECReported = FALSE, limit = 10)

}
}
