% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R, R/crs.R, R/sp_mesh.R
\name{fmesher-deprecated}
\alias{fmesher-deprecated}
\alias{fm_spTransform}
\alias{fm_spTransform.default}
\alias{fm_spTransform.SpatialPoints}
\alias{fm_spTransform.SpatialPointsDataFrame}
\alias{fm_has_PROJ6}
\alias{fm_as_sp_crs}
\alias{fm_sp_get_crs}
\alias{fm_sp2segment}
\title{Deprecated functions in fmesher}
\usage{
fm_spTransform(x, ...)

\method{fm_spTransform}{default}(x, crs0 = NULL, crs1 = NULL, passthrough = FALSE, ...)

\method{fm_spTransform}{SpatialPoints}(x, CRSobj, passthrough = FALSE, ...)

\method{fm_spTransform}{SpatialPointsDataFrame}(x, CRSobj, passthrough = FALSE, ...)

fm_has_PROJ6()

fm_as_sp_crs(x, ...)

fm_sp_get_crs(x)

fm_sp2segment(...)
}
\arguments{
\item{x}{A \code{sp::Spatial} object}

\item{\dots}{Potential additional arguments}

\item{crs0}{The source sp::CRS or inla.CRS object}

\item{crs1}{The target sp::CRS or inla.CRS object}

\item{passthrough}{Default is FALSE.
Setting to TRUE allows objects with no CRS information to be passed
through without transformation.}

\item{CRSobj}{The target sp::CRS or inla.CRS object}
}
\value{
A \code{CRS} object, or NULL if no valid CRS identified
}
\description{
These functions still attempt to do their job, but will be removed in a
future version.
}
\details{
This function is a convenience method to workaround PROJ4/PROJ6
differences, and the lack of a crs extraction method for Spatial objects.
For newer code, use \code{\link[=fm_crs]{fm_crs()}} instead, that returns \code{crs} objects, and use
\link[=fm_crs]{fm_CRS()} to extract/construct/convert to old style \code{sp::CRS} objects.
}
\section{Functions}{
\itemize{
\item \code{fm_spTransform()}: \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} (See \code{\link[=fm_transform]{fm_transform()}} instead)
Handle transformation of various inla objects according to coordinate
reference systems of \code{sp::CRS} or \code{INLA::inla.CRS} class.

\item \code{fm_spTransform(default)}: The default method handles low level
transformation of raw coordinates.

\item \code{fm_has_PROJ6()}: Old checker for PROJ6.

\item \code{fm_as_sp_crs()}: Wrapper for \code{\link[=fm_CRS]{fm_CRS()}}
\code{sp::Spatial} and \code{sp::CRS} objects.

\item \code{fm_sp_get_crs()}: Wrapper for \code{CRS(projargs)} (PROJ4) and
\code{CRS(wkt)} for \code{sp::Spatial} objects.

\item \code{fm_sp2segment()}: \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} in favour
of \code{\link[=fm_as_segm]{fm_as_segm()}}

}}
\examples{
if (fm_safe_sp()) {
  s <- sp::SpatialPoints(matrix(1:6, 3, 2), proj4string = fm_CRS("sphere"))
  fm_CRS(s)
}
}
\seealso{
\code{\link[=fm_transform]{fm_transform()}}
}
\author{
Finn Lindgren \email{finn.lindgren@gmail.com}
}
