% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{fmesher_subdivide}
\alias{fmesher_subdivide}
\title{Split triangles}
\usage{
fmesher_subdivide(
  mesh_loc,
  mesh_tv,
  mesh_boundary,
  mesh_interior,
  subdivisions,
  options
)
}
\arguments{
\item{mesh_loc}{numeric matrix; mesh vertex coordinates}

\item{mesh_tv}{3-column integer matrix with 0-based vertex indices for each triangle}

\item{mesh_boundary}{2-column integer matrix with 0-based vertex indices for
boundary constraints}

\item{mesh_interior}{2-column integer matrix with 0-based vertex indices for
interior constraints}

\item{subdivisions}{integer; number of new points along each edge.}

\item{options}{list of triangulation options (\code{sphere_tolerance})}
}
\value{
A list of line splitting information objects
}
\description{
Subdivide a mesh with congruent subtriangles
}
\examples{
mesh <- fm_mesh_2d(
  boundary = fm_segm(rbind(c(0,0), c(1,0), c(1,1), c(0, 1)), is.bnd = TRUE)
)
splitter <- fm_segm(rbind(c(0.8, 0.2), c(0.2, 0.8)))
segm_split <- fm_split_lines(mesh, splitter)
}
\seealso{
\code{\link[=fm_split_lines]{fm_split_lines()}}
}
