% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date-counters.R
\name{is_valid_day_basis}
\alias{is_valid_day_basis}
\alias{daybasisconventions}
\title{Day basis conventions}
\usage{
is_valid_day_basis(day_basis)
}
\arguments{
\item{day_basis}{A character vector of day basis conventions.}
}
\value{
will return \code{TRUE} for \code{day_basis} elements that are any of the
following: \code{30/360}, \code{30/360us}, \code{30e/360},
\code{30e/360isda}, \code{30e+/360}, \code{act/360}, \code{act/365} and
\code{act/actisda}. Otherwise will return \code{FALSE}
}
\description{
Checks whether day basis conventions are valid. Supported day basis
conventions are documented in \code{\link[=year_frac]{year_frac()}}
}
\examples{
is_valid_day_basis(c("act/360", "act/365f"))
}
\seealso{
Other counter methods: \code{\link{actual_360}},
  \code{\link{actual_365}},
  \code{\link{actual_actual_isda}},
  \code{\link{thirty_360_eu_isda}},
  \code{\link{thirty_360_eu_plus}},
  \code{\link{thirty_360_eu}}, \code{\link{thirty_360_us}},
  \code{\link{thirty_360}}, \code{\link{year_frac}}
}
