% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_mirror.R
\name{kernel_mirror}
\alias{kernel_mirror}
\alias{kernel_nmirror}
\alias{kernel_umirror}
\title{Mirror Transition Kernels}
\usage{
kernel_nmirror(
  mu = 0,
  scale = 1,
  warmup = 500L,
  nadapt = 4L,
  arate = 0.4,
  lb = -.Machine$double.xmax,
  ub = .Machine$double.xmax,
  fixed = FALSE,
  scheme = "joint"
)

kernel_umirror(
  mu = 0,
  scale = 1,
  warmup = 500L,
  nadapt = 4L,
  arate = 0.4,
  lb = -.Machine$double.xmax,
  ub = .Machine$double.xmax,
  fixed = FALSE,
  scheme = "joint"
)
}
\arguments{
\item{mu, scale}{Either a numeric vector or a scalar. Proposal mean and scale.
If scalar, values are recycled to match the number of parameters in the
objective function.}

\item{warmup}{Integer. Number of steps required before starting adapting the
chains.}

\item{nadapt}{Integer. Number of times the scale is adjusted for adaptation
during the warmup (burn-in) period.}

\item{arate}{Double. Target acceptance rate used as a reference during the
adaptation process.}

\item{lb, ub}{Either a numeric vector or a scalar. Lower and upper bounds for
bounded kernels. When of length 1, the values are recycled to match the number
of parameters in the objective function.}

\item{fixed, scheme}{For multivariate functions, sets the update plan.
See \code{\link[=plan_update_sequence]{plan_update_sequence()}}.}
}
\value{
An object of class \link{fmcmc_kernel}. \code{fmcmc_kernel} objects are intended
to be used with the \code{\link[=MCMC]{MCMC()}} function.
}
\description{
NMirror and UMirror transition kernels described in Thawornwattana et al.
(2018).
}
\details{
The \code{kernel_nmirror} and \code{kernel_umirror} functions implement simple symmetric
transition kernels that pivot around an approximation of the asymptotic mean.

In the multidimensional case, this implementation just draws a vector of
independent draws from the proposal kernel, instead of using, for example,
a multivariate distribution of some kind. This will be implemented in the
next update of the package.

During the warmup period (or burnin as described in the paper), the algorithm
adapts both the scale and the reference mean of the proposal distribution.
While the mean is adapted continuously, the scale is updated only a handful
of times, in particular, \code{nadapt} times during the warmup time. The adaptation
is done as proposed by Yang and Rodriguez (2013) in which the
scale is adapted four times.
}
\examples{
# Normal mirror kernel with 5 adaptations and 1000 steps of warmup (burnin)
kern <- kernel_nmirror(nadapt = 5, warmup = 1000)

# Same as before but using a uniform mirror and choosing a target acceptance
# rate of 24 \%
kern <- kernel_umirror(nadapt = 5, warmup = 1000, arate = .24)
}
\references{
Thawornwattana, Y., Dalquen, D., & Yang, Z. (2018). Designing Simple and
Efficient Markov Chain Monte Carlo Proposal Kernels. Bayesian Analysis, 13(4),
1037–1063. \url{https://doi.org/10.1214/17-BA1084}

Yang, Z., & Rodriguez, C. E. (2013). Searching for efficient Markov chain
Monte Carlo proposal kernels. Proceedings of the National Academy of Sciences,
110(48), 19307–19312. \url{https://doi.org/10.1073/pnas.1311790110}
}
\seealso{
Other kernels: 
\code{\link{kernel_adapt}()},
\code{\link{kernel_new}()},
\code{\link{kernel_normal}()},
\code{\link{kernel_ram}()},
\code{\link{kernel_unif}()}
}
\concept{kernels}
