% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flight_simulation.R
\name{flysim}
\alias{flysim}
\title{Range Estimation}
\usage{
flysim(file, header = TRUE, sep = ",", quote = "\"", dec = ".",
             fill = TRUE, comment.char = "", ..., data = NULL,
             settings = list())
}
\arguments{
\item{file}{Arguments for path to data.}

\item{header}{Logical. If TRUE use first row as column headers}

\item{sep}{separator}

\item{quote}{The set of quoting characters. see read.csv}

\item{dec}{The character used in the file for decimal points.}

\item{fill}{See read.csv}

\item{comment.char}{For more details see read.csv}

\item{...}{further arguments see read.csv}

\item{data}{A data frame.}

\item{settings}{A list for re-defining constants. See details.}
}
\value{
S3 class object with range estimates based on methods defined and
       settings used
\itemize{
   \item range estimates (Km)
   \item settings used
   \item data
}
}
\description{
Practical range estimation of birds using methods in Pennycuik (1975)
Mechanics of Flight. These methods are based on Breguet equations.
}
\details{
The option *settings takes the arguments (those particulary
required by this function)
\itemize{
   \item ppc: Profile power constant
   \item eFat: Energy content of fuel from fat
   \item g: Accelaration due to gravity
   \item mce: Mechanical conversion efficiency [0,1]
   \item ipf: Induced power factor
   \item vcp: Ventilation and circulation power
   \item airDensity: Air density at cruising altitude
   \item bdc: Body drag coefficient
   \item alpha: Basal metabolism factors in passerines and non passerines
   \item delta: Basal metabolism factors in passerines and non passerines
   alpha*bodyMass^delta
}
}
\examples{
flysim(data = birds, settings = list(eFat = 3.89*10^7))
flysim(data = birds,  settings = list(airDensity = 0.905))

}
\author{
Brian Masinde
}
