% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kill-flow.R
\name{kill}
\alias{kill}
\alias{kill.character}
\alias{kill.flow}
\title{Kill all jobs submitted to the computing platform, for one or multiple flows}
\usage{
kill(x, ...)

\method{kill}{character}(x, force = FALSE, ...)

\method{kill}{flow}(x, kill_cmd, verbose = opts_flow$get("verbose"),
  jobid_col = "job_sub_id", ...)
}
\arguments{
\item{x}{either path to flow wd or object of class \link{flow}}

\item{...}{not used}

\item{force}{You need to set force=TRUE, to kill multiple flows. This makes sure multiple flows are NOT killed by accident.}

\item{kill_cmd}{The command used to kill. flowr tries to guess this commands, as defined in the detect_kill_cmd(). Supplying
it here; fot custom platoforms.}

\item{verbose}{A numeric value indicating the amount of messages to produce.
 Values are integers varying from 0, 1, 2, 3, .... Please refer to the \link{verbose} page for more details.
\code{opts_flow$get("verbose")}}

\item{jobid_col}{Advanced use. The column name in 'flow_details.txt' file used to fetch jobids to kill}
}
\description{
NOTE:

\strong{This requires files which are created at the end of the \link{submit_flow} command}.

Even if you want to kill the flow, its best to let submit_flow do its job, when done simply use \code{kill(flow_wd)}. 
If submit_flow is interrupted, files like flow_details.rds etc are not created, thus flowr looses the association 
of jobs with flow instance and cannot monitor, kill or re-run the flow.
}
\examples{

\dontrun{

## example for terminal
## flowr kill_flow x=path_to_flow_directory
## In case path matches multiple folders, flowr asks before killing
kill(x='fastq_haplotyper*')
 Flowr: streamlining workflows
 found multiple wds:
 /fastq_haplotyper-MS132-20150825-16-24-04-0Lv1PbpI
 /fastq_haplotyper-MS132-20150825-17-47-52-5vFIkrMD
 Really kill all of them ? kill again with force=TRUE

## submitting again with force=TRUE will kill them:
kill(x='fastq_haplotyper*', force = TRUE)
}
}

