% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_binomial.R
\name{get_binomial}
\alias{get_binomial}
\title{Extract the binomial name (Genus + specific epithet) from a Scientific Name}
\usage{
get_binomial(species_names)
}
\arguments{
\item{species_names}{(character) Scientific names to be converted to
binomial names}
}
\value{
A vector with the binomial names (Genus + specific epithet).
}
\description{
Extract the binomial name (Genus + specific epithet) from a Scientific Name
}
\examples{
spp <- c("Araucaria angustifolia (Bertol.) Kuntze",
"Butia catarinensis Noblick & Lorenzi",
"Adesmia paranensis Burkart")
spp_new <- get_binomial(species_names = spp)
spp_new

}
