% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/two-sample-stats.R
\name{test-statistic}
\alias{test-statistic}
\alias{stat_hotelling}
\alias{stat_t}
\alias{stat_f}
\alias{stat_mean}
\title{Test Statistics for the Two-Sample Problem}
\usage{
stat_hotelling(data, indices, ...)

stat_t(data, indices, ...)

stat_f(data, indices, ...)

stat_mean(data, indices, ...)
}
\arguments{
\item{data}{A list of the \code{n1 + n2} concatenated observations with the
original \code{n1} observations from the first sample on top and the original
\code{n2} observations from the second sample below.}

\item{indices}{An integer vector giving the indices in \code{data} that are
considered to belong to the first sample.}

\item{...}{Extra parameters (might be useful for other user-supplied
\verb{stat_*()} functions). Not used here.}
}
\value{
A real scalar giving the value of Hotelling's $T^2$ statistic.
}
\description{
This function implements the original Hotelling's $T^2$ statistic which is
defined for multivariate data when the number $n$ of observations is greater
than the number $p$ of variables.
}
\examples{
n <- 10L
mx <- 0
sigma <- 1

# Two different models for the two populations
x <- rnorm(n = n, mean = mx, sd = sigma)
x <- as.list(x)
delta <- 10
my <- mx + delta
y <- rnorm(n = n, mean = my, sd = sigma)
y <- as.list(y)
stat_hotelling(c(x, y), 1:n)
stat_t(c(x, y), 1:n)
stat_mean(c(x, y), 1:n)
}
