\name{flip.object-class}
\Rdversion{1.1}
\docType{class}
\alias{draw}
\alias{p.value}
\alias{plot}
\alias{size}
\alias{result}
\alias{flip.object-class}
\alias{[,flip.object-method}
\alias{[[,flip.object-method}
\alias{hist,flip.object-method}
\alias{length,flip.object-method}
\alias{names,flip.object-method}
\alias{names<-,flip.object-method}
\alias{p.value,flip.object-method}
\alias{plot,flip.object-method}
\alias{result,flip.object-method}
\alias{show,flip.object-method}
\alias{size,flip.object-method}
\alias{sort,flip.object-method}
\alias{summary,flip.object-method}
\alias{p.adjust,flip.object-method}
\alias{numericOrmatrixOrNULL-class}
\alias{arrayOrNULL-class}
\alias{data.frameOrNULL-class}
\alias{numericOrmatrixOrNULL}
\alias{arrayOrNULL}
\alias{data.frameOrNULL}
\title{Class "flip.object" for storing the result of the function flip}
\description{	
The class flip.object is the output of a call to
\code{\link{flip}}. It stores the information needed for various diagnostic plots. }
\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("flip.object", ...)}.
}
\section{Slots}{
  \describe{
    \item{\code{res}:}{Object of class \code{flip.object} }
    \item{\code{call}:}{Object of class \code{"call"} }
    \item{\code{permP}:}{A matrix p-values of size B x p (number of permutations x number of variables), first line representing the p-value computed on observed data.}
    \item{\code{permT}:}{A matrix test statistics of size B x p (number of permutations x number of variables), first line representing the test statistic computed on observed data.}
    \item{\code{permSpace}:}{ A matrix permutation of size B x n (number of permutations x sampel size), first line representing the p-value computed on observed data. This matrix is usually generated by \code{make.permSpace} or
\code{make.signSpace}}
    \item{\code{permY}:}{Not implemented yet}
    \item{\code{nperms}:}{\code{list} with two elements \code{number} of permutation and the \code{seed} to be used for generation of random permutations (it can be \code{NULL}, it is \code{NA} when all permutations are computed).}
    \item{\code{tail}:}{tail of the alternative. 1 means right tail, -1 left tail and 0 is bidirectional alternative}
  }
}
\section{Methods}{
  \describe{
    \item{[}{\code{signature(x = "flip.object")}: ... }
    \item{[[}{\code{signature(x = "flip.object")}: ... }
    \item{hist}{\code{signature(x = "flip.object")}: ... }
    \item{length}{\code{signature(x = "flip.object")}: ... }
    \item{names}{\code{signature(x = "flip.object")}: ... }
    \item{names<-}{\code{signature(x = "flip.object")}: ... }
    \item{p.value}{\code{signature(object = "flip.object")}: ... }
	\item{p.adjust}{\code{signature(object = "flip.object")}: ... }
    \item{plot}{\code{signature(x = "flip.object", y = "missing")}: ... }
    \item{result}{\code{signature(object = "flip.object")}: ... }
    \item{show}{\code{signature(object = "flip.object")}: ... }
    \item{size}{\code{signature(object = "flip.object")}: ... }
    \item{sort}{\code{signature(x = "flip.object")}: ... }
    \item{summary}{\code{signature(object = "flip.object")}: ... }
	 }
}

\author{livio finos}
\examples{
showClass("flip.object")
}
\keyword{classes}