% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{lp_distance}
\alias{lp_distance}
\title{Fast \eqn{l_p^p} Distance Vector Computation}
\usage{
lp_distance(X, p)
}
\arguments{
\item{X}{double matrix (arma::mat class)}

\item{p}{numeric Minkowski power (double class)}
}
\value{
vector of \eqn{l_p^p} distances (arma::vec class)
}
\description{
Takes in a double matrix X, whose transpose t(X)
has N rows, and computes a vector recording all
\eqn{{N \choose 2}} pairwise \eqn{l_p^p} distances of t(X),
ordered lexicographically.
}
\examples{
# X = [[0.5,0.5],[0,1],[0.3,0.7]] --> lPVec = [x,y,z]
# with x = (0.5^p + 0.5^p)
}
