% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.R
\name{distDataPermute}
\alias{distDataPermute}
\title{p-value Computation for Test of Exchangeability Using Distance Data}
\usage{
distDataPermute(dist_list, nruns)
}
\arguments{
\item{dist_list}{The list (length \eqn{B}) of pairwise distance data. 
Each element in list should be either a distance matrix or a table recording
pairwise distances.}

\item{nruns}{The resampling number (use at least 1000)}
}
\value{
The p-value obtained from comparing the empirical tail cdf of the observed 
\eqn{V} statistic computed from distance data.
}
\description{
Generates a block permutation p-value.
}
\details{
Generates a block permutation distribution of \eqn{V} statistic by storing
the provided list of distance data as an \eqn{{N\choose2} \times B} array,
and then permuting the underlying indices of each individual to generate 
resampled \eqn{{N\choose2} \times B} arrays. The observed \eqn{V} statistic is 
also computed from the distance data.   

Each element of dist_list should be a \eqn{N\times N} distance matrix.

Dependencies: buildForward, buildReverse, cachePermute
}
