% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pop.R
\name{pop}
\alias{pop}
\title{Retrieve an object from a stack}
\usage{
pop(.stack)
}
\arguments{
\item{.stack}{A stack.}
}
\value{
The object retrieved. 
If \code{.stack} is empty, an error is thrown.
}
\description{
The \code{pop} function retrieves the first reachable 
object from \code{.stack}.
}
\details{
The \code{pop} function is not pure. Side effect is that 
\code{.stack} is modified in the calling environment.
}
\examples{
(s <- lifo(max_length = 3)) # empty LIFO
(push(s, 0.3)) #
(push(s, data.frame(x=1:2, y=2:3))) 
obj <- pop(s) # get the last element inserted

}
\seealso{
\code{\link[flifo]{push}}.
}
