% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DoU-classify-grid-urban-clusters.R
\name{DoU_classify_grid_urban_clusters}
\alias{DoU_classify_grid_urban_clusters}
\title{Create the DEGURBA grid cell classification of urban clusters}
\usage{
DoU_classify_grid_urban_clusters(
  data,
  classification,
  density_threshold = 300,
  size_threshold = 5000,
  contiguity_rule = 8,
  smooth_pop = FALSE,
  smooth_pop_window = 5,
  value = 2
)
}
\arguments{
\item{data}{path to the directory with the data, or named list with the data as returned by function \code{\link[=DoU_preprocess_grid]{DoU_preprocess_grid()}}}

\item{classification}{SpatRaster. A grid with the classification of urban centres to which the classification of urban clusters will be added. Note that the grid will be adapted in-place.}

\item{density_threshold}{numeric. Minimum population density per permanent land of a cell required to belong to an urban cluster}

\item{size_threshold}{numeric. Minimum total population size required for an urban cluster}

\item{contiguity_rule}{integer. Which cells are considered adjacent: \code{4} for rooks case (horizontal and vertical neighbours) or \code{8} for queens case (horizontal, vertical and diagonal neighbours)}

\item{smooth_pop}{logical. Whether to smooth the population grid before delineating urban clusters. If \code{TRUE}, the population grid will be smoothed with a moving average of window size \code{smooth_pop_window}.}

\item{smooth_pop_window}{integer. Size of the moving window used to smooth the population grid before delineating urban clusters. Ignored when \code{smooth_pop} is \code{FALSE}.}

\item{value}{integer. Value assigned to urban clusters in the resulting grid}
}
\value{
SpatRaster with the grid cell classification of urban clusters
}
\description{
The Degree of Urbanisation identifies urban clusters as clusters of continuous grid cells (based on queen contiguity) with a minimum density of 300 inhabitants per km², and a minimum total population of 5000 inhabitants.

For more information about the Degree of Urbanisation methodology, see the \href{https://ec.europa.eu/eurostat/statistics-explained/index.php?title=Applying_the_degree_of_urbanisation_manual}{methodological manual}, \href{https://ghsl.jrc.ec.europa.eu/documents/GHSL_Data_Package_2022.pdf}{GHSL Data Package 2022} and \href{https://ghsl.jrc.ec.europa.eu/documents/GHSL_Data_Package_2023.pdf}{GHSL Data Package 2023}.

The arguments of the function allow to adapt the standard specifications in the Degree of Urbanisation in order to construct an alternative version of the grid classification.
}
\examples{
data_belgium <- DoU_load_grid_data_belgium()
classification <- DoU_classify_grid_urban_centres(data_belgium)
classification <- DoU_classify_grid_urban_clusters(data_belgium, classification = classification)
DoU_plot_grid(classification)
}
