% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarizor.R
\name{fmt_header_n}
\alias{fmt_header_n}
\title{Format count data for headers}
\usage{
fmt_header_n(n)
}
\arguments{
\item{n}{count values}
}
\description{
The function formats counts as \verb{\\n(N=XX)}. This helper
function is used to add counts in columns titles.
}
\examples{
library(flextable)

df <- data.frame(zz = 1)

ft_1 <- flextable(df)
ft_1 <- append_chunks(
  x = ft_1, j = 1, part = "header",
  value = as_chunk(fmt_header_n(200)))
ft_1 <- autofit(ft_1)
ft_1
}
\seealso{
\code{\link[=tabulator]{tabulator()}}, \code{\link[=mk_par]{mk_par()}}

Other text formatter functions: 
\code{\link{fmt_2stats}()},
\code{\link{fmt_avg_dev}()},
\code{\link{fmt_dbl}()},
\code{\link{fmt_int}()},
\code{\link{fmt_n_percent}()},
\code{\link{fmt_pct}()}
}
\concept{text formatter functions}
